<?php

use Illuminate\Database\Seeder;
use App\Models\Currency;
class CurrencySeeder extends Seeder {

    public function run() {
        // Uncomment the below to wipe the table clean before populating
        Currency::truncate();

        $currencies = [ 
                     [
                       'iso'=>'AED',
                       'name'=>'United Arab Emirates Dirham',
                       'symbol'=>'د.إ',
                       'subunit'=>'Fils',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'784'],
                    [
                       'iso'=>'AFN',
                       'name'=>'Afghan Afghani',
                       'symbol'=>'؋',
                       'subunit'=>'Pul',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'971'],
                    [
                       'iso'=>'ALL',
                       'name'=>'Albanian Lek',
                       'symbol'=>'L',
                       'subunit'=>'Qintar',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'008'],
                    [
                       'iso'=>'AMD',
                       'name'=>'Armenian Dram',
                       'symbol'=>'դր.',
                       'subunit'=>'Luma',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'051'],
                    [
                       'iso'=>'ANG',
                       'name'=>'Netherlands Antillean Gulden',
                       'symbol'=>'ƒ',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x0192;',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'532'],
                    [
                       'iso'=>'AOA',
                       'name'=>'Angolan Kwanza',
                       'symbol'=>'Kz',
                       'subunit'=>'Cêntimo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'973'],
                    [
                       'iso'=>'ARS',
                       'name'=>'Argentine Peso',
                       'symbol'=>'$',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20B1;',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'032'],
                    ['priority'=>'4',
                       'iso'=>'AUD',
                       'name'=>'Australian Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'036'],
                    [
                       'iso'=>'AWG',
                       'name'=>'Aruban Florin',
                       'symbol'=>'ƒ',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x0192;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'533'],
                    [
                       'iso'=>'AZN',
                       'name'=>'Azerbaijani Manat',
                       'symbol'=>'null',
                       'subunit'=>'Qəpik',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'944'],
                    [
                       'iso'=>'BAM',
                       'name'=>'Bosnia and Herzegovina Convertible Mark',
                       'symbol'=>'КМ',
                       'subunit'=>'Fening',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'977'],
                    [
                       'iso'=>'BBD',
                       'name'=>'Barbadian Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'052'],
                    [
                       'iso'=>'BDT',
                       'name'=>'Bangladeshi Taka',
                       'symbol'=>'৳',
                       'subunit'=>'Paisa',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'050'],
                    [
                       'iso'=>'BGN',
                       'name'=>'Bulgarian Lev',
                       'symbol'=>'лв',
                       'subunit'=>'Stotinka',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'975'],
                    [
                       'iso'=>'BHD',
                       'name'=>'Bahraini Dinar',
                       'symbol'=>'ب.د',
                       'subunit'=>'Fils',
                       'subunit_to_unit'=>'1000',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'048'],
                    [
                       'iso'=>'BIF',
                       'name'=>'Burundian Franc',
                       'symbol'=>'Fr',
                       'subunit'=>'Centime',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'108'],
                    [
                       'iso'=>'BMD',
                       'name'=>'Bermudian Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'060'],
                    [
                       'iso'=>'BND',
                       'name'=>'Brunei Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Sen',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'096'],
                    [
                       'iso'=>'BOB',
                       'name'=>'Bolivian Boliviano',
                       'symbol'=>'Bs.',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'068'],
                    [
                       'iso'=>'BRL',
                       'name'=>'Brazilian Real',
                       'symbol'=>'R$',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'R$',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'986'],
                    [
                       'iso'=>'BSD',
                       'name'=>'Bahamian Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'044'],
                    [
                       'iso'=>'BTN',
                       'name'=>'Bhutanese Ngultrum',
                       'symbol'=>'Nu.',
                       'subunit'=>'Chertrum',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'064'],
                    [
                       'iso'=>'BWP',
                       'name'=>'Botswana Pula',
                       'symbol'=>'P',
                       'subunit'=>'Thebe',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'072'],
                    [
                       'iso'=>'BYR',
                       'name'=>'Belarusian Ruble',
                       'symbol'=>'Br',
                       'subunit'=>'Kapyeyka',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'974'],
                    [
                       'iso'=>'BZD',
                       'name'=>'Belize Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'084'],
                    ['priority'=>'5',
                       'iso'=>'CAD',
                       'name'=>'Canadian Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'124'],
                    [
                       'iso'=>'CDF',
                       'name'=>'Congolese Franc',
                       'symbol'=>'Fr',
                       'subunit'=>'Centime',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'976'],
                    [
                       'iso'=>'CHF',
                       'name'=>'Swiss Franc',
                       'symbol'=>'Fr',
                       'subunit'=>'Rappen',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'756'],
                    [
                       'iso'=>'CLF',
                       'name'=>'Unidad de Fomento',
                       'symbol'=>'UF',
                       'subunit'=>'Peso',
                       'subunit_to_unit'=>'1',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20B1;',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'990'],
                    [
                       'iso'=>'CLP',
                       'name'=>'Chilean Peso',
                       'symbol'=>'$',
                       'subunit'=>'Peso',
                       'subunit_to_unit'=>'1',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#36;',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'152'],
                    [
                       'iso'=>'CNY',
                       'name'=>'Chinese Renminbi Yuan',
                       'symbol'=>'¥',
                       'subunit'=>'Fen',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#20803;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'156'],
                    [
                       'iso'=>'COP',
                       'name'=>'Colombian Peso',
                       'symbol'=>'$',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20B1;',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'170'],
                    [
                       'iso'=>'CRC',
                       'name'=>'Costa Rican Colón',
                       'symbol'=>'₡',
                       'subunit'=>'Céntimo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20A1;',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'188'],
                    [
                       'iso'=>'CUC',
                       'name'=>'Cuban Convertible Peso',
                       'symbol'=>'$',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'931'],
                    [
                       'iso'=>'CUP',
                       'name'=>'Cuban Peso',
                       'symbol'=>'$',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20B1;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'192'],
                    [
                       'iso'=>'CVE',
                       'name'=>'Cape Verdean Escudo',
                       'symbol'=>'$',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'132'],
                    [
                       'iso'=>'CZK',
                       'name'=>'Czech Koruna',
                       'symbol'=>'Kč',
                       'subunit'=>'Haléř',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'203'],
                    [
                       'iso'=>'DJF',
                       'name'=>'Djiboutian Franc',
                       'symbol'=>'Fdj',
                       'subunit'=>'Centime',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'262'],
                    [
                       'iso'=>'DKK',
                       'name'=>'Danish Krone',
                       'symbol'=>'kr',
                       'subunit'=>'Øre',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'208'],
                    [
                       'iso'=>'DOP',
                       'name'=>'Dominican Peso',
                       'symbol'=>'$',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20B1;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'214'],
                    [
                       'iso'=>'DZD',
                       'name'=>'Algerian Dinar',
                       'symbol'=>'د.ج',
                       'subunit'=>'Centime',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'012'],
                    [
                       'iso'=>'EGP',
                       'name'=>'Egyptian Pound',
                       'symbol'=>'ج.م',
                       'subunit'=>'Piastre',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x00A3;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'818'],
                    [
                       'iso'=>'ERN',
                       'name'=>'Eritrean Nakfa',
                       'symbol'=>'Nfk',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'232'],
                    [
                       'iso'=>'ETB',
                       'name'=>'Ethiopian Birr',
                       'symbol'=>'Br',
                       'subunit'=>'Santim',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'230'],
                    ['priority'=>'2',
                       'iso'=>'EUR',
                       'name'=>'Euro',
                       'symbol'=>'€',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20AC;',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'978'],
                    [
                       'iso'=>'FJD',
                       'name'=>'Fijian Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'242'],
                    [
                       'iso'=>'FKP',
                       'name'=>'Falkland Pound',
                       'symbol'=>'£',
                       'subunit'=>'Penny',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x00A3;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'238'],
                    ['priority'=>'3',
                       'iso'=>'GBP',
                       'name'=>'British Pound',
                       'symbol'=>'£',
                       'subunit'=>'Penny',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x00A3;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'826'],
                    [
                       'iso'=>'GEL',
                       'name'=>'Georgian Lari',
                       'symbol'=>'ლ',
                       'subunit'=>'Tetri',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'981'],
                    [
                       'iso'=>'GHS',
                       'name'=>'Ghanaian Cedi',
                       'symbol'=>'₵',
                       'subunit'=>'Pesewa',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20B5;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'936'],
                    [
                       'iso'=>'GIP',
                       'name'=>'Gibraltar Pound',
                       'symbol'=>'£',
                       'subunit'=>'Penny',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x00A3;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'292'],
                    [
                       'iso'=>'GMD',
                       'name'=>'Gambian Dalasi',
                       'symbol'=>'D',
                       'subunit'=>'Butut',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'270'],
                    [
                       'iso'=>'GNF',
                       'name'=>'Guinean Franc',
                       'symbol'=>'Fr',
                       'subunit'=>'Centime',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'324'],
                    [
                       'iso'=>'GTQ',
                       'name'=>'Guatemalan Quetzal',
                       'symbol'=>'Q',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'320'],
                    [
                       'iso'=>'GYD',
                       'name'=>'Guyanese Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'328'],
                    [
                       'iso'=>'HKD',
                       'name'=>'Hong Kong Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'344'],
                    [
                       'iso'=>'HNL',
                       'name'=>'Honduran Lempira',
                       'symbol'=>'L',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'340'],
                    [
                       'iso'=>'HRK',
                       'name'=>'Croatian Kuna',
                       'symbol'=>'kn',
                       'subunit'=>'Lipa',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'191'],
                    [
                       'iso'=>'HTG',
                       'name'=>'Haitian Gourde',
                       'symbol'=>'G',
                       'subunit'=>'Centime',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'332'],
                    [
                       'iso'=>'HUF',
                       'name'=>'Hungarian Forint',
                       'symbol'=>'Ft',
                       'subunit'=>'Fillér',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'348'],
                    [
                       'iso'=>'IDR',
                       'name'=>'Indonesian Rupiah',
                       'symbol'=>'Rp',
                       'subunit'=>'Sen',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'360'],
                    [
                       'iso'=>'ILS',
                       'name'=>'Israeli New Sheqel',
                       'symbol'=>'₪',
                       'subunit'=>'Agora',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20AA;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'376'],
                    [
                       'iso'=>'INR',
                       'name'=>'Indian Rupee',
                       'symbol'=>'₹',
                       'subunit'=>'Paisa',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20b9;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'356'],
                    [
                       'iso'=>'IQD',
                       'name'=>'Iraqi Dinar',
                       'symbol'=>'ع.د',
                       'subunit'=>'Fils',
                       'subunit_to_unit'=>'1000',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'368'],
                    [
                       'iso'=>'IRR',
                       'name'=>'Iranian Rial',
                       'symbol'=>'﷼',
                       'subunit'=>'Dinar',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#xFDFC;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'364'],
                    [
                       'iso'=>'ISK',
                       'name'=>'Icelandic Króna',
                       'symbol'=>'kr',
                       'subunit'=>'Eyrir',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'352'],
                    [
                       'iso'=>'JMD',
                       'name'=>'Jamaican Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'388'],
                    [
                       'iso'=>'JOD',
                       'name'=>'Jordanian Dinar',
                       'symbol'=>'د.ا',
                       'subunit'=>'Piastre',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'400'],
                    ['priority'=>'6',
                       'iso'=>'JPY',
                       'name'=>'Japanese Yen',
                       'symbol'=>'¥',
                       'subunit'=>'null',
                       'subunit_to_unit'=>'1',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x00A5;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'392'],
                    [
                       'iso'=>'KES',
                       'name'=>'Kenyan Shilling',
                       'symbol'=>'KSh',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'404'],
                    [
                       'iso'=>'KGS',
                       'name'=>'Kyrgyzstani Som',
                       'symbol'=>'som',
                       'subunit'=>'Tyiyn',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'417'],
                    [
                       'iso'=>'KHR',
                       'name'=>'Cambodian Riel',
                       'symbol'=>'៛',
                       'subunit'=>'Sen',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x17DB;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'116'],
                    [
                       'iso'=>'KMF',
                       'name'=>'Comorian Franc',
                       'symbol'=>'Fr',
                       'subunit'=>'Centime',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'174'],
                    [
                       'iso'=>'KPW',
                       'name'=>'North Korean Won',
                       'symbol'=>'₩',
                       'subunit'=>'Chŏn',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x20A9;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'408'],
                    [
                       'iso'=>'KRW',
                       'name'=>'South Korean Won',
                       'symbol'=>'₩',
                       'subunit'=>'null',
                       'subunit_to_unit'=>'1',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20A9;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'410'],
                    [
                       'iso'=>'KWD',
                       'name'=>'Kuwaiti Dinar',
                       'symbol'=>'د.ك',
                       'subunit'=>'Fils',
                       'subunit_to_unit'=>'1000',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'414'],
                    [
                       'iso'=>'KYD',
                       'name'=>'Cayman Islands Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'136'],
                    [
                       'iso'=>'KZT',
                       'name'=>'Kazakhstani Tenge',
                       'symbol'=>'〒',
                       'subunit'=>'Tiyn',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'398'],
                    [
                       'iso'=>'LAK',
                       'name'=>'Lao Kip',
                       'symbol'=>'₭',
                       'subunit'=>'Att',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x20AD;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'418'],
                    [
                       'iso'=>'LBP',
                       'name'=>'Lebanese Pound',
                       'symbol'=>'ل.ل',
                       'subunit'=>'Piastre',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x00A3;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'422'],
                    [
                       'iso'=>'LKR',
                       'name'=>'Sri Lankan Rupee',
                       'symbol'=>'₨',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x0BF9;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'144'],
                    [
                       'iso'=>'LRD',
                       'name'=>'Liberian Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'430'],
                    [
                       'iso'=>'LSL',
                       'name'=>'Lesotho Loti',
                       'symbol'=>'L',
                       'subunit'=>'Sente',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'426'],
                    [
                       'iso'=>'LTL',
                       'name'=>'Lithuanian Litas',
                       'symbol'=>'Lt',
                       'subunit'=>'Centas',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'440'],
                    [
                       'iso'=>'LVL',
                       'name'=>'Latvian Lats',
                       'symbol'=>'Ls',
                       'subunit'=>'Santīms',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'428'],
                    [
                       'iso'=>'LYD',
                       'name'=>'Libyan Dinar',
                       'symbol'=>'ل.د',
                       'subunit'=>'Dirham',
                       'subunit_to_unit'=>'1000',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'434'],
                    [
                       'iso'=>'MAD',
                       'name'=>'Moroccan Dirham',
                       'symbol'=>'د.م.',
                       'subunit'=>'Centime',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'504'],
                    [
                       'iso'=>'MDL',
                       'name'=>'Moldovan Leu',
                       'symbol'=>'L',
                       'subunit'=>'Ban',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'498'],
                    [
                       'iso'=>'MGA',
                       'name'=>'Malagasy Ariary',
                       'symbol'=>'Ar',
                       'subunit'=>'Iraimbilanja',
                       'subunit_to_unit'=>'5',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'969'],
                    [
                       'iso'=>'MKD',
                       'name'=>'Macedonian Denar',
                       'symbol'=>'ден',
                       'subunit'=>'Deni',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'807'],
                    [
                       'iso'=>'MMK',
                       'name'=>'Myanmar Kyat',
                       'symbol'=>'K',
                       'subunit'=>'Pya',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'104'],
                    [
                       'iso'=>'MNT',
                       'name'=>'Mongolian Tögrög',
                       'symbol'=>'₮',
                       'subunit'=>'Möngö',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x20AE;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'496'],
                    [
                       'iso'=>'MOP',
                       'name'=>'Macanese Pataca',
                       'symbol'=>'P',
                       'subunit'=>'Avo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'446'],
                    [
                       'iso'=>'MRO',
                       'name'=>'Mauritanian Ouguiya',
                       'symbol'=>'UM',
                       'subunit'=>'Khoums',
                       'subunit_to_unit'=>'5',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'478'],
                    [
                       'iso'=>'MUR',
                       'name'=>'Mauritian Rupee',
                       'symbol'=>'₨',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20A8;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'480'],
                    [
                       'iso'=>'MVR',
                       'name'=>'Maldivian Rufiyaa',
                       'symbol'=>'MVR',
                       'subunit'=>'Laari',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'462'],
                    [
                       'iso'=>'MWK',
                       'name'=>'Malawian Kwacha',
                       'symbol'=>'MK',
                       'subunit'=>'Tambala',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'454'],
                    [
                       'iso'=>'MXN',
                       'name'=>'Mexican Peso',
                       'symbol'=>'$',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'484'],
                    [
                       'iso'=>'MYR',
                       'name'=>'Malaysian Ringgit',
                       'symbol'=>'RM',
                       'subunit'=>'Sen',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'458'],
                    [
                       'iso'=>'MZN',
                       'name'=>'Mozambican Metical',
                       'symbol'=>'MTn',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'943'],
                    [
                       'iso'=>'NAD',
                       'name'=>'Namibian Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'516'],
                    [
                       'iso'=>'NGN',
                       'name'=>'Nigerian Naira',
                       'symbol'=>'₦',
                       'subunit'=>'Kobo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x20A6;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'566'],
                    [
                       'iso'=>'NIO',
                       'name'=>'Nicaraguan Córdoba',
                       'symbol'=>'C$',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'558'],
                    [
                       'iso'=>'NOK',
                       'name'=>'Norwegian Krone',
                       'symbol'=>'kr',
                       'subunit'=>'Øre',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'kr',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'578'],
                    [
                       'iso'=>'NPR',
                       'name'=>'Nepalese Rupee',
                       'symbol'=>'₨',
                       'subunit'=>'Paisa',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20A8;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'524'],
                    [
                       'iso'=>'NZD',
                       'name'=>'New Zealand Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'554'],
                    [
                       'iso'=>'OMR',
                       'name'=>'Omani Rial',
                       'symbol'=>'ر.ع.',
                       'subunit'=>'Baisa',
                       'subunit_to_unit'=>'1000',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#xFDFC;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'512'],
                    [
                       'iso'=>'PAB',
                       'name'=>'Panamanian Balboa',
                       'symbol'=>'B/.',
                       'subunit'=>'Centésimo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'590'],
                    [
                       'iso'=>'PEN',
                       'name'=>'Peruvian Nuevo Sol',
                       'symbol'=>'S/.',
                       'subunit'=>'Céntimo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'S/.',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'604'],
                    [
                       'iso'=>'PGK',
                       'name'=>'Papua New Guinean Kina',
                       'symbol'=>'K',
                       'subunit'=>'Toea',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'598'],
                    [
                       'iso'=>'PHP',
                       'name'=>'Philippine Peso',
                       'symbol'=>'₱',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20B1;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'608'],
                    [
                       'iso'=>'PKR',
                       'name'=>'Pakistani Rupee',
                       'symbol'=>'₨',
                       'subunit'=>'Paisa',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20A8;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'586'],
                    [
                       'iso'=>'PLN',
                       'name'=>'Polish Złoty',
                       'symbol'=>'zł',
                       'subunit'=>'Grosz',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'z&#322;',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'',
                       'iso_numeric'=>'985'],
                    [
                       'iso'=>'PYG',
                       'name'=>'Paraguayan Guaraní',
                       'symbol'=>'₲',
                       'subunit'=>'Céntimo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20B2;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'600'],
                    [
                       'iso'=>'QAR',
                       'name'=>'Qatari Riyal',
                       'symbol'=>'ر.ق',
                       'subunit'=>'Dirham',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#xFDFC;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'634'],
                    [
                       'iso'=>'RON',
                       'name'=>'Romanian Leu',
                       'symbol'=>'Lei',
                       'subunit'=>'Bani',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'946'],
                    [
                       'iso'=>'RSD',
                       'name'=>'Serbian Dinar',
                       'symbol'=>'РСД',
                       'subunit'=>'Para',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'941'],
                    [
                       'iso'=>'RUB',
                       'name'=>'Russian Ruble',
                       'symbol'=>'р.',
                       'subunit'=>'Kopek',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x0440;&#x0443;&#x0431;',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'643'],
                    [
                       'iso'=>'RWF',
                       'name'=>'Rwandan Franc',
                       'symbol'=>'FRw',
                       'subunit'=>'Centime',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'646'],
                    [
                       'iso'=>'SAR',
                       'name'=>'Saudi Riyal',
                       'symbol'=>'ر.س',
                       'subunit'=>'Hallallah',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#xFDFC;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'682'],
                    [
                       'iso'=>'SBD',
                       'name'=>'Solomon Islands Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'090'],
                    [
                       'iso'=>'SCR',
                       'name'=>'Seychellois Rupee',
                       'symbol'=>'₨',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x20A8;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'690'],
                    [
                       'iso'=>'SDG',
                       'name'=>'Sudanese Pound',
                       'symbol'=>'£',
                       'subunit'=>'Piastre',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'938'],
                    [
                       'iso'=>'SEK',
                       'name'=>'Swedish Krona',
                       'symbol'=>'kr',
                       'subunit'=>'Öre',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'',
                       'iso_numeric'=>'752'],
                    [
                       'iso'=>'SGD',
                       'name'=>'Singapore Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'702'],
                    [
                       'iso'=>'SHP',
                       'name'=>'Saint Helenian Pound',
                       'symbol'=>'£',
                       'subunit'=>'Penny',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x00A3;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'654'],
                    [
                       'iso'=>'SKK',
                       'name'=>'Slovak Koruna',
                       'symbol'=>'Sk',
                       'subunit'=>'Halier',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'703'],
                    [
                       'iso'=>'SLL',
                       'name'=>'Sierra Leonean Leone',
                       'symbol'=>'Le',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'694'],
                    [
                       'iso'=>'SOS',
                       'name'=>'Somali Shilling',
                       'symbol'=>'Sh',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'706'],
                    [
                       'iso'=>'SRD',
                       'name'=>'Surinamese Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'968'],
                    [
                       'iso'=>'SSP',
                       'name'=>'South Sudanese Pound',
                       'symbol'=>'£',
                       'subunit'=>'piaster',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x00A3;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'728'],
                    [
                       'iso'=>'STD',
                       'name'=>'São Tomé and Príncipe Dobra',
                       'symbol'=>'Db',
                       'subunit'=>'Cêntimo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'678'],
                    [
                       'iso'=>'SVC',
                       'name'=>'Salvadoran Colón',
                       'symbol'=>'₡',
                       'subunit'=>'Centavo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20A1;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'222'],
                    [
                       'iso'=>'SYP',
                       'name'=>'Syrian Pound',
                       'symbol'=>'£S',
                       'subunit'=>'Piastre',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x00A3;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'760'],
                    [
                       'iso'=>'SZL',
                       'name'=>'Swazi Lilangeni',
                       'symbol'=>'L',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'748'],
                    [
                       'iso'=>'THB',
                       'name'=>'Thai Baht',
                       'symbol'=>'฿',
                       'subunit'=>'Satang',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x0E3F;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'764'],
                    [
                       'iso'=>'TJS',
                       'name'=>'Tajikistani Somoni',
                       'symbol'=>'ЅМ',
                       'subunit'=>'Diram',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'972'],
                    [
                       'iso'=>'TMT',
                       'name'=>'Turkmenistani Manat',
                       'symbol'=>'T',
                       'subunit'=>'Tenge',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'934'],
                    [
                       'iso'=>'TND',
                       'name'=>'Tunisian Dinar',
                       'symbol'=>'د.ت',
                       'subunit'=>'Millime',
                       'subunit_to_unit'=>'1000',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'788'],
                    [
                       'iso'=>'TOP',
                       'name'=>'Tongan Paʻanga',
                       'symbol'=>'T$',
                       'subunit'=>'Seniti',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'776'],
                    [
                       'iso'=>'TRY',
                       'name'=>'Turkish Lira',
                       'symbol'=>'TL',
                       'subunit'=>'kuruş',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'949'],
                    [
                       'iso'=>'TTD',
                       'name'=>'Trinidad and Tobago Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'780'],
                    [
                       'iso'=>'TWD',
                       'name'=>'New Taiwan Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'901'],
                    [
                       'iso'=>'TZS',
                       'name'=>'Tanzanian Shilling',
                       'symbol'=>'Sh',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'834'],
                    [
                       'iso'=>'UAH',
                       'name'=>'Ukrainian Hryvnia',
                       'symbol'=>'₴',
                       'subunit'=>'Kopiyka',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#x20B4;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'980'],
                    [
                       'iso'=>'UGX',
                       'name'=>'Ugandan Shilling',
                       'symbol'=>'USh',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'800'],
                    ['priority'=>'1',
                       'iso'=>'USD',
                       'name'=>'United States Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'840'],
                    [
                       'iso'=>'UYU',
                       'name'=>'Uruguayan Peso',
                       'symbol'=>'$',
                       'subunit'=>'Centésimo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20B1;',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'858'],
                    [
                       'iso'=>'UZS',
                       'name'=>'Uzbekistani Som',
                       'symbol'=>'null',
                       'subunit'=>'Tiyin',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'860'],
                    [
                       'iso'=>'VEF',
                       'name'=>'Venezuelan Bolívar',
                       'symbol'=>'Bs F',
                       'subunit'=>'Céntimo',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'937'],
                    [
                       'iso'=>'VND',
                       'name'=>'Vietnamese Đồng',
                       'symbol'=>'₫',
                       'subunit'=>'Hào',
                       'subunit_to_unit'=>'10',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x20AB;',
                       'decimal_mark'=>',',
                       'thousands_separator'=>'.',
                       'iso_numeric'=>'704'],
                    [
                       'iso'=>'VUV',
                       'name'=>'Vanuatu Vatu',
                       'symbol'=>'Vt',
                       'subunit'=>'null',
                       'subunit_to_unit'=>'1',
                       'symbol_first'=>'true',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'548'],
                    [
                       'iso'=>'WST',
                       'name'=>'Samoan Tala',
                       'symbol'=>'T',
                       'subunit'=>'Sene',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'882'],
                    [
                       'iso'=>'XAF',
                       'name'=>'Central African Cfa Franc',
                       'symbol'=>'Fr',
                       'subunit'=>'Centime',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'950'],
                    [
                       'iso'=>'XAG',
                       'name'=>'Silver (Troy Ounce)',
                       'symbol'=>'oz t',
                       'subunit'=>'oz',
                       'subunit_to_unit'=>'1',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'961'],
                    [
                       'iso'=>'XAU',
                       'name'=>'Gold (Troy Ounce)',
                       'symbol'=>'oz t',
                       'subunit'=>'oz',
                       'subunit_to_unit'=>'1',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'959'],
                    [
                       'iso'=>'XCD',
                       'name'=>'East Caribbean Dollar',
                       'symbol'=>'$',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'951'],
                    [
                       'iso'=>'XDR',
                       'name'=>'Special Drawing Rights',
                       'symbol'=>'SDR',
                       'subunit'=>'',
                       'subunit_to_unit'=>'1',
                       'symbol_first'=>'false',
                       'html_entity'=>'$',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'960'],
                    [
                       'iso'=>'XOF',
                       'name'=>'West African Cfa Franc',
                       'symbol'=>'Fr',
                       'subunit'=>'Centime',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'952'],
                    [
                       'iso'=>'XPF',
                       'name'=>'Cfp Franc',
                       'symbol'=>'Fr',
                       'subunit'=>'Centime',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'953'],
                    [
                       'iso'=>'YER',
                       'name'=>'Yemeni Rial',
                       'symbol'=>'﷼',
                       'subunit'=>'Fils',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'&#xFDFC;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'886'],
                    [
                       'iso'=>'ZAR',
                       'name'=>'South African Rand',
                       'symbol'=>'R',
                       'subunit'=>'Cent',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'true',
                       'html_entity'=>'&#x0052;',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'710'],
                    [
                       'iso'=>'ZMK',
                       'name'=>'Zambian Kwacha',
                       'symbol'=>'ZK',
                       'subunit'=>'Ngwee',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'894'],
                    [
                       'iso'=>'ZMW',
                       'name'=>'Zambian Kwacha',
                       'symbol'=>'ZK',
                       'subunit'=>'Ngwee',
                       'subunit_to_unit'=>'100',
                       'symbol_first'=>'false',
                       'html_entity'=>'',
                       'decimal_mark'=>'.',
                       'thousands_separator'=>',',
                       'iso_numeric'=>'967']
        ];

//                 $currencies = [ ['code''=>''USD',
//   'symbol''=>''$',
//   'unicode''=>''&#36;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''EUR',
//   'symbol''=>''€',
//   'unicode''=>''&#128;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''CAD',
//   'symbol''=>''$',
//   'unicode''=>''&#36;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''GBP',
//   'symbol''=>''£',
//   'unicode''=>''&#163;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''AUD',
//   'symbol''=>''$',
//   'unicode''=>''&#36;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''AED',
//   'symbol''=>''د.إ',
//   'unicode''=>''',
//   'position''=>''after',
//   'comments''=>''Can not find' ],
//  ['code''=>''ANG',
//   'symbol''=>''ƒ',
//   'unicode''=>''&#x0192;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''AOA',
//   'symbol''=>''AOA',
//   'unicode''=>''AOA',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''ARS',
//   'symbol''=>''$',
//   'unicode''=>''&#36;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''BAM',
//   'symbol''=>''KM',
//   'unicode''=>''KM',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''BBD',
//   'symbol''=>''$',
//   'unicode''=>''&#36;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''BGL',
//   'symbol''=>''лв',
//   'unicode''=>''&#1083;&#1074;',
//   'position''=>''before',
//   'comments''=>''ISO code is actually BGN' ],
//  ['code''=>''BHD',
//   'symbol''=>''BD',
//   'unicode''=>''BD',
//   'position''=>''after',
//   'comments''=>''' ],
//  ['code''=>''BND',
//   'symbol''=>''$',
//   'unicode''=>''&#36;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''BRL',
//   'symbol''=>''R$',
//   'unicode''=>''R&#36;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''CHF',
//   'symbol''=>''Fr',
//   'unicode''=>''Fr',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''CLF',
//   'symbol''=>''UF',
//   'unicode''=>''UF',
//   'position''=>''after',
//   'comments''=>''' ],
//  ['code''=>''CLP',
//   'symbol''=>''$',
//   'unicode''=>''&#36;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''CNY',
//   'symbol''=>''¥',
//   'unicode''=>''&#165;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''COP',
//   'symbol''=>''$',
//   'unicode''=>''&#36;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''CRC',
//   'symbol''=>''₡',
//   'unicode''=>''&#x20A1;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''CZK',
//   'symbol''=>''Kč',
//   'unicode''=>''K&#269;',
//   'position''=>''after',
//   'comments''=>''' ],
//  ['code''=>''DKK',
//   'symbol''=>''kr',
//   'unicode''=>''kr',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''EEK',
//   'symbol''=>''KR',
//   'unicode''=>''KR',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''EGP',
//   'symbol''=>''E£',
//   'unicode''=>''E&#163;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''FJD',
//   'symbol''=>''FJ$',
//   'unicode''=>''FJ&#36;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''GTQ',
//   'symbol''=>''Q',
//   'unicode''=>''Q',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''HKD',
//   'symbol''=>''$',
//   'unicode''=>''&#36;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''HRK',
//   'symbol''=>''kn',
//   'unicode''=>''kn',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''HUF',
//   'symbol''=>''Ft',
//   'unicode''=>''Ft',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''IDR',
//   'symbol''=>''Rp',
//   'unicode''=>''Rp',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''ILS',
//   'symbol''=>''₪',
//   'unicode''=>''&#x20AA;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''INR',
//   'symbol''=>''Rs',
//   'unicode''=>''Rs',
//   'position''=>''before',
//   'comments''=>''There is not a unicode' ],
//  ['code''=>''JOD',
//   'symbol''=>''د.ا',
//   'unicode''=>''',
//   'position''=>''',
//   'comments''=>''Can not find' ],
//  ['code''=>''JPY',
//   'symbol''=>''¥',
//   'unicode''=>''&#165;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''KES',
//   'symbol''=>''KSh',
//   'unicode''=>''Ksh',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''KRW',
//   'symbol''=>''₩',
//   'unicode''=>''&#x20A9;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''KWD',
//   'symbol''=>''KD',
//   'unicode''=>''KD',
//   'position''=>''after',
//   'comments''=>''' ],
//  ['code''=>''KYD',
//   'symbol''=>''$',
//   'unicode''=>''&#36;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''LTL',
//   'symbol''=>''Lt',
//   'unicode''=>''Lt',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''LVL',
//   'symbol''=>''Ls',
//   'unicode''=>''Ls',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''MAD',
//   'symbol''=>''د.م.',
//   'unicode''=>''',
//   'position''=>''',
//   'comments''=>''Can not find' ],
//  ['code''=>''MVR',
//   'symbol''=>''Rf',
//   'unicode''=>''Rf',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''MXN',
//   'symbol''=>''$',
//   'unicode''=>''&#36;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''MYR',
//   'symbol''=>''RM',
//   'unicode''=>''RM',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''NGN',
//   'symbol''=>''₦',
//   'unicode''=>''&#x20A6;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''NOK',
//   'symbol''=>''kr',
//   'unicode''=>''kr',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''NZD',
//   'symbol''=>''$',
//   'unicode''=>''&#36;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''OMR',
//   'symbol''=>''OMR',
//   'unicode''=>''&#65020;',
//   'position''=>''after',
//   'comments''=>''Unsure if this is correct' ],
//  ['code''=>''PEN',
//   'symbol''=>''S/.',
//   'unicode''=>''S/.',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''PHP',
//   'symbol''=>''₱',
//   'unicode''=>''&#x20B1;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''PLN',
//   'symbol''=>''zł',
//   'unicode''=>''Z&#322;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''QAR',
//   'symbol''=>''QAR',
//   'unicode''=>''&#65020;',
//   'position''=>''after',
//   'comments''=>''Unsure if this is correct' ],
//  ['code''=>''RON',
//   'symbol''=>''lei',
//   'unicode''=>''lei',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''RUB',
//   'symbol''=>''руб.',
//   'unicode''=>''&#1088;&#1091;&#1073;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''SAR',
//   'symbol''=>''SAR',
//   'unicode''=>''&#65020;',
//   'position''=>''after',
//   'comments''=>''Unsure if this is correct' ],
//  ['code''=>''SEK',
//   'symbol''=>''kr',
//   'unicode''=>''kr',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''SGD',
//   'symbol''=>''$',
//   'unicode''=>''&#36;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''THB',
//   'symbol''=>''฿',
//   'unicode''=>''&#322;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''TRY',
//   'symbol''=>''TL',
//   'unicode''=>''TL',
//   'position''=>''before',
//   'comments''=>''There is not a unicode' ],
//  ['code''=>''TTD',
//   'symbol''=>''$',
//   'unicode''=>''&#36;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''TWD',
//   'symbol''=>''$',
//   'unicode''=>''&#36;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''UAH',
//   'symbol''=>''₴',
//   'unicode''=>''&#8372;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''VEF',
//   'symbol''=>''Bs F',
//   'unicode''=>''Bs.',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''VND',
//   'symbol''=>''₫',
//   'unicode''=>''&#x20AB;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''XCD',
//   'symbol''=>''$',
//   'unicode''=>''&#36;',
//   'position''=>''before',
//   'comments''=>''' ],
//  ['code''=>''ZAR',
//   'symbol''=>''R',
//   'unicode''=>''R',
//   'position''=>''before',
//   'comments''=>''' ] ];
        // Uncomment the below to run the seeder
        foreach($currencies as $currency)
        {
           Currency::create([
              'iso'=>$currency['iso'],
              'name'=>$currency['name'],
              'symbol'=>$currency['symbol'],
           ]);
        }
    }

}
