
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
/*!50717 SELECT COUNT(*) INTO @rocksdb_has_p_s_session_variables FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = 'performance_schema' AND TABLE_NAME = 'session_variables' */;
/*!50717 SET @rocksdb_get_is_supported = IF (@rocksdb_has_p_s_session_variables, 'SELECT COUNT(*) INTO @rocksdb_is_supported FROM performance_schema.session_variables WHERE VARIABLE_NAME=\'rocksdb_bulk_load\'', 'SELECT 0') */;
/*!50717 PREPARE s FROM @rocksdb_get_is_supported */;
/*!50717 EXECUTE s */;
/*!50717 DEALLOCATE PREPARE s */;
/*!50717 SET @rocksdb_enable_bulk_load = IF (@rocksdb_is_supported, 'SET SESSION rocksdb_bulk_load = 1', 'SET @rocksdb_dummy_bulk_load = 0') */;
/*!50717 PREPARE s FROM @rocksdb_enable_bulk_load */;
/*!50717 EXECUTE s */;
/*!50717 DEALLOCATE PREPARE s */;
DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `activity_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject_id` bigint(20) unsigned DEFAULT NULL,
  `causer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `causer_id` bigint(20) unsigned DEFAULT NULL,
  `properties` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `subject` (`subject_type`,`subject_id`),
  KEY `causer` (`causer_type`,`causer_id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `activity_log` WRITE;
/*!40000 ALTER TABLE `activity_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `activity_log` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `antibiotics`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `antibiotics` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shortcut` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `commercial_name` longtext COLLATE utf8mb4_unicode_ci,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `antibiotics` WRITE;
/*!40000 ALTER TABLE `antibiotics` DISABLE KEYS */;
/*!40000 ALTER TABLE `antibiotics` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `branches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `branches` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lat` double(8,2) DEFAULT NULL,
  `lng` double(8,2) DEFAULT NULL,
  `zoom_level` int(11) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `branches` WRITE;
/*!40000 ALTER TABLE `branches` DISABLE KEYS */;
INSERT INTO `branches` VALUES (1,'Main Branch','Egypt','+201063955280',27.77,30.88,8,NULL,'2022-11-05 04:38:50','2022-11-05 04:38:50');
/*!40000 ALTER TABLE `branches` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `chats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `chats` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `from` int(10) unsigned DEFAULT NULL,
  `to` int(10) unsigned DEFAULT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `read` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `chats` WRITE;
/*!40000 ALTER TABLE `chats` DISABLE KEYS */;
/*!40000 ALTER TABLE `chats` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contracts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contracts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `discount` double(8,2) unsigned NOT NULL DEFAULT '0.00',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contracts` WRITE;
/*!40000 ALTER TABLE `contracts` DISABLE KEYS */;
/*!40000 ALTER TABLE `contracts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `culture_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `culture_options` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `culture_options` WRITE;
/*!40000 ALTER TABLE `culture_options` DISABLE KEYS */;
INSERT INTO `culture_options` VALUES (1,'Organism',0,NULL,NULL,NULL),(2,'Colony Count',0,NULL,NULL,NULL),(3,'Condition',0,NULL,NULL,NULL),(4,'opt 1',1,NULL,NULL,NULL),(5,'opt 2',1,NULL,NULL,NULL),(6,'opt 1',2,NULL,NULL,NULL),(7,'opt 2',2,NULL,NULL,NULL),(8,'opt 1',3,NULL,NULL,NULL),(9,'opt 2',3,NULL,NULL,NULL);
/*!40000 ALTER TABLE `culture_options` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cultures`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cultures` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sample_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `precautions` text COLLATE utf8mb4_unicode_ci,
  `price` double DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cultures` WRITE;
/*!40000 ALTER TABLE `cultures` DISABLE KEYS */;
INSERT INTO `cultures` VALUES (1,'Blood Culture',NULL,NULL,100,NULL,'2022-11-05 04:38:50','2022-11-05 04:38:50');
/*!40000 ALTER TABLE `cultures` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currencies` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `iso` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `symbol` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=165 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES (1,'AED','United Arab Emirates Dirham','د.إ'),(2,'AFN','Afghan Afghani','؋'),(3,'ALL','Albanian Lek','L'),(4,'AMD','Armenian Dram','դր.'),(5,'ANG','Netherlands Antillean Gulden','ƒ'),(6,'AOA','Angolan Kwanza','Kz'),(7,'ARS','Argentine Peso','$'),(8,'AUD','Australian Dollar','$'),(9,'AWG','Aruban Florin','ƒ'),(10,'AZN','Azerbaijani Manat','null'),(11,'BAM','Bosnia and Herzegovina Convertible Mark','КМ'),(12,'BBD','Barbadian Dollar','$'),(13,'BDT','Bangladeshi Taka','৳'),(14,'BGN','Bulgarian Lev','лв'),(15,'BHD','Bahraini Dinar','ب.د'),(16,'BIF','Burundian Franc','Fr'),(17,'BMD','Bermudian Dollar','$'),(18,'BND','Brunei Dollar','$'),(19,'BOB','Bolivian Boliviano','Bs.'),(20,'BRL','Brazilian Real','R$'),(21,'BSD','Bahamian Dollar','$'),(22,'BTN','Bhutanese Ngultrum','Nu.'),(23,'BWP','Botswana Pula','P'),(24,'BYR','Belarusian Ruble','Br'),(25,'BZD','Belize Dollar','$'),(26,'CAD','Canadian Dollar','$'),(27,'CDF','Congolese Franc','Fr'),(28,'CHF','Swiss Franc','Fr'),(29,'CLF','Unidad de Fomento','UF'),(30,'CLP','Chilean Peso','$'),(31,'CNY','Chinese Renminbi Yuan','¥'),(32,'COP','Colombian Peso','$'),(33,'CRC','Costa Rican Colón','₡'),(34,'CUC','Cuban Convertible Peso','$'),(35,'CUP','Cuban Peso','$'),(36,'CVE','Cape Verdean Escudo','$'),(37,'CZK','Czech Koruna','Kč'),(38,'DJF','Djiboutian Franc','Fdj'),(39,'DKK','Danish Krone','kr'),(40,'DOP','Dominican Peso','$'),(41,'DZD','Algerian Dinar','د.ج'),(42,'EGP','Egyptian Pound','ج.م'),(43,'ERN','Eritrean Nakfa','Nfk'),(44,'ETB','Ethiopian Birr','Br'),(45,'EUR','Euro','€'),(46,'FJD','Fijian Dollar','$'),(47,'FKP','Falkland Pound','£'),(48,'GBP','British Pound','£'),(49,'GEL','Georgian Lari','ლ'),(50,'GHS','Ghanaian Cedi','₵'),(51,'GIP','Gibraltar Pound','£'),(52,'GMD','Gambian Dalasi','D'),(53,'GNF','Guinean Franc','Fr'),(54,'GTQ','Guatemalan Quetzal','Q'),(55,'GYD','Guyanese Dollar','$'),(56,'HKD','Hong Kong Dollar','$'),(57,'HNL','Honduran Lempira','L'),(58,'HRK','Croatian Kuna','kn'),(59,'HTG','Haitian Gourde','G'),(60,'HUF','Hungarian Forint','Ft'),(61,'IDR','Indonesian Rupiah','Rp'),(62,'ILS','Israeli New Sheqel','₪'),(63,'INR','Indian Rupee','₹'),(64,'IQD','Iraqi Dinar','ع.د'),(65,'IRR','Iranian Rial','﷼'),(66,'ISK','Icelandic Króna','kr'),(67,'JMD','Jamaican Dollar','$'),(68,'JOD','Jordanian Dinar','د.ا'),(69,'JPY','Japanese Yen','¥'),(70,'KES','Kenyan Shilling','KSh'),(71,'KGS','Kyrgyzstani Som','som'),(72,'KHR','Cambodian Riel','៛'),(73,'KMF','Comorian Franc','Fr'),(74,'KPW','North Korean Won','₩'),(75,'KRW','South Korean Won','₩'),(76,'KWD','Kuwaiti Dinar','د.ك'),(77,'KYD','Cayman Islands Dollar','$'),(78,'KZT','Kazakhstani Tenge','〒'),(79,'LAK','Lao Kip','₭'),(80,'LBP','Lebanese Pound','ل.ل'),(81,'LKR','Sri Lankan Rupee','₨'),(82,'LRD','Liberian Dollar','$'),(83,'LSL','Lesotho Loti','L'),(84,'LTL','Lithuanian Litas','Lt'),(85,'LVL','Latvian Lats','Ls'),(86,'LYD','Libyan Dinar','ل.د'),(87,'MAD','Moroccan Dirham','د.م.'),(88,'MDL','Moldovan Leu','L'),(89,'MGA','Malagasy Ariary','Ar'),(90,'MKD','Macedonian Denar','ден'),(91,'MMK','Myanmar Kyat','K'),(92,'MNT','Mongolian Tögrög','₮'),(93,'MOP','Macanese Pataca','P'),(94,'MRO','Mauritanian Ouguiya','UM'),(95,'MUR','Mauritian Rupee','₨'),(96,'MVR','Maldivian Rufiyaa','MVR'),(97,'MWK','Malawian Kwacha','MK'),(98,'MXN','Mexican Peso','$'),(99,'MYR','Malaysian Ringgit','RM'),(100,'MZN','Mozambican Metical','MTn'),(101,'NAD','Namibian Dollar','$'),(102,'NGN','Nigerian Naira','₦'),(103,'NIO','Nicaraguan Córdoba','C$'),(104,'NOK','Norwegian Krone','kr'),(105,'NPR','Nepalese Rupee','₨'),(106,'NZD','New Zealand Dollar','$'),(107,'OMR','Omani Rial','ر.ع.'),(108,'PAB','Panamanian Balboa','B/.'),(109,'PEN','Peruvian Nuevo Sol','S/.'),(110,'PGK','Papua New Guinean Kina','K'),(111,'PHP','Philippine Peso','₱'),(112,'PKR','Pakistani Rupee','₨'),(113,'PLN','Polish Złoty','zł'),(114,'PYG','Paraguayan Guaraní','₲'),(115,'QAR','Qatari Riyal','ر.ق'),(116,'RON','Romanian Leu','Lei'),(117,'RSD','Serbian Dinar','РСД'),(118,'RUB','Russian Ruble','р.'),(119,'RWF','Rwandan Franc','FRw'),(120,'SAR','Saudi Riyal','ر.س'),(121,'SBD','Solomon Islands Dollar','$'),(122,'SCR','Seychellois Rupee','₨'),(123,'SDG','Sudanese Pound','£'),(124,'SEK','Swedish Krona','kr'),(125,'SGD','Singapore Dollar','$'),(126,'SHP','Saint Helenian Pound','£'),(127,'SKK','Slovak Koruna','Sk'),(128,'SLL','Sierra Leonean Leone','Le'),(129,'SOS','Somali Shilling','Sh'),(130,'SRD','Surinamese Dollar','$'),(131,'SSP','South Sudanese Pound','£'),(132,'STD','São Tomé and Príncipe Dobra','Db'),(133,'SVC','Salvadoran Colón','₡'),(134,'SYP','Syrian Pound','£S'),(135,'SZL','Swazi Lilangeni','L'),(136,'THB','Thai Baht','฿'),(137,'TJS','Tajikistani Somoni','ЅМ'),(138,'TMT','Turkmenistani Manat','T'),(139,'TND','Tunisian Dinar','د.ت'),(140,'TOP','Tongan Paʻanga','T$'),(141,'TRY','Turkish Lira','TL'),(142,'TTD','Trinidad and Tobago Dollar','$'),(143,'TWD','New Taiwan Dollar','$'),(144,'TZS','Tanzanian Shilling','Sh'),(145,'UAH','Ukrainian Hryvnia','₴'),(146,'UGX','Ugandan Shilling','USh'),(147,'USD','United States Dollar','$'),(148,'UYU','Uruguayan Peso','$'),(149,'UZS','Uzbekistani Som','null'),(150,'VEF','Venezuelan Bolívar','Bs F'),(151,'VND','Vietnamese Đồng','₫'),(152,'VUV','Vanuatu Vatu','Vt'),(153,'WST','Samoan Tala','T'),(154,'XAF','Central African Cfa Franc','Fr'),(155,'XAG','Silver (Troy Ounce)','oz t'),(156,'XAU','Gold (Troy Ounce)','oz t'),(157,'XCD','East Caribbean Dollar','$'),(158,'XDR','Special Drawing Rights','SDR'),(159,'XOF','West African Cfa Franc','Fr'),(160,'XPF','Cfp Franc','Fr'),(161,'YER','Yemeni Rial','﷼'),(162,'ZAR','South African Rand','R'),(163,'ZMK','Zambian Kwacha','ZK'),(164,'ZMW','Zambian Kwacha','ZK');
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `doctors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `doctors` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `commission` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `doctors` WRITE;
/*!40000 ALTER TABLE `doctors` DISABLE KEYS */;
/*!40000 ALTER TABLE `doctors` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expense_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expense_categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expense_categories` WRITE;
/*!40000 ALTER TABLE `expense_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `expense_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expenses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expenses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `expense_category_id` int(11) DEFAULT NULL,
  `amount` double NOT NULL DEFAULT '0',
  `date` date DEFAULT NULL,
  `notes` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `doctor_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expenses` WRITE;
/*!40000 ALTER TABLE `expenses` DISABLE KEYS */;
/*!40000 ALTER TABLE `expenses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_culture_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_culture_options` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `group_culture_id` int(11) DEFAULT NULL,
  `culture_option_id` int(11) DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_culture_options` WRITE;
/*!40000 ALTER TABLE `group_culture_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_culture_options` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_culture_results`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_culture_results` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `group_culture_id` int(11) DEFAULT NULL,
  `antibiotic_id` int(11) DEFAULT NULL,
  `sensitivity` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_culture_results` WRITE;
/*!40000 ALTER TABLE `group_culture_results` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_culture_results` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_cultures`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_cultures` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` int(11) DEFAULT NULL,
  `culture_id` int(11) DEFAULT NULL,
  `price` double(8,2) DEFAULT NULL,
  `done` tinyint(1) NOT NULL DEFAULT '0',
  `comment` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_cultures` WRITE;
/*!40000 ALTER TABLE `group_cultures` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_cultures` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_test_results`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_test_results` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `group_test_id` int(11) DEFAULT NULL,
  `test_id` int(11) DEFAULT NULL,
  `result` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_test_results` WRITE;
/*!40000 ALTER TABLE `group_test_results` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_test_results` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_tests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `group_tests` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` int(11) DEFAULT NULL,
  `test_id` int(11) DEFAULT NULL,
  `price` double(8,2) DEFAULT NULL,
  `has_results` tinyint(1) NOT NULL DEFAULT '0',
  `has_entered` tinyint(1) NOT NULL DEFAULT '0',
  `done` tinyint(1) NOT NULL DEFAULT '0',
  `comment` longtext COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_tests` WRITE;
/*!40000 ALTER TABLE `group_tests` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_tests` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `branch_id` int(10) unsigned DEFAULT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `doctor_id` int(11) DEFAULT NULL,
  `contract_id` int(11) DEFAULT NULL,
  `discount` double(8,2) NOT NULL DEFAULT '0.00',
  `subtotal` double(8,2) NOT NULL DEFAULT '0.00',
  `total` double(8,2) NOT NULL DEFAULT '0.00',
  `paid` double(8,2) NOT NULL DEFAULT '0.00',
  `due` double(8,2) NOT NULL DEFAULT '0.00',
  `done` tinyint(1) NOT NULL DEFAULT '0',
  `report_pdf` text COLLATE utf8mb4_unicode_ci,
  `receipt_pdf` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `barcode` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `doctor_commission` double NOT NULL DEFAULT '0',
  `signature` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `languages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `iso` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `rtl` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'ar',1,NULL,NULL,1),(2,'en',1,NULL,NULL,0),(3,'de',1,NULL,NULL,0),(4,'es',1,NULL,NULL,0),(5,'et',1,NULL,NULL,0),(6,'fa',1,NULL,NULL,1),(7,'fr',1,NULL,NULL,0),(8,'id',1,NULL,NULL,0),(9,'it',1,NULL,NULL,0),(10,'nl',1,NULL,NULL,0),(11,'de',1,NULL,NULL,0),(12,'pl',1,NULL,NULL,0),(13,'pt',1,NULL,NULL,0),(14,'ro',1,NULL,NULL,0),(15,'ru',1,NULL,NULL,0),(16,'th',1,NULL,NULL,0),(17,'tr',1,NULL,NULL,0),(18,'pt-br',1,NULL,NULL,0),(19,'zh-cn',1,NULL,NULL,0),(20,'zh-tw',1,NULL,NULL,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2016_06_01_000001_create_oauth_auth_codes_table',1),(2,'2016_06_01_000002_create_oauth_access_tokens_table',1),(3,'2016_06_01_000003_create_oauth_refresh_tokens_table',1),(4,'2016_06_01_000004_create_oauth_clients_table',1),(5,'2016_06_01_000005_create_oauth_personal_access_clients_table',1),(6,'2020_06_291_023147_create_patients_table',1),(7,'2020_06_29_0231471_create_group_tests_table',1),(8,'2020_06_29_0231471_create_groups_table',1),(9,'2020_06_29_023147_create_antibiotics_table',1),(10,'2020_06_29_023147_create_cultures_table',1),(11,'2020_06_29_023147_create_currencies_table',1),(12,'2020_06_29_023147_create_doctors_table',1),(13,'2020_06_29_023147_create_failed_jobs_table',1),(14,'2020_06_29_023147_create_group_culture_results_table',1),(15,'2020_06_29_023147_create_group_cultures_table',1),(16,'2020_06_29_023147_create_group_test_results_table',1),(17,'2020_06_29_023147_create_password_resets_table',1),(18,'2020_06_29_023147_create_permissions_table',1),(19,'2020_06_29_023147_create_role_permissions_table',1),(20,'2020_06_29_023147_create_roles_table',1),(21,'2020_06_29_023147_create_settings_table',1),(22,'2020_06_29_023147_create_user_roles_table',1),(23,'2020_06_29_023147_create_users_table',1),(24,'2020_07_14_164944_create_chats_table',1),(25,'2020_07_19_0402311212_create_visits_table',1),(26,'2020_07_23_00134911_create_branches_table',1),(27,'2020_07_25_0846441_create_contracts_table',1),(28,'2020_07_26_174857_create_expenses_table',1),(29,'2020_07_26_180427_create_expense_categories_table',1),(30,'2020_09_19_01584112_create_component_options_table',1),(31,'2020_09_21_081815_create_tests_table',1),(32,'2020_09_21_090444_create_culture_options_table',1),(33,'2020_09_22_000304_create_activity_log_table',1),(34,'2020_09_23_06421111_create_group_culture_options',1),(35,'2020_09_28_005305_create_modules_table',1),(36,'2020_10_13_163657_create_languages_table',1),(37,'2021_01_07_055724_add_direction_to_languages_table',1),(38,'2021_03_11_152345_add_barcode_to_groups_table',1),(39,'2021_03_12_112340_add_commission_to_doctors',1),(40,'2021_03_12_120501_add_doctor_commission_to_groups_table',1),(41,'2021_03_12_121735_add_doctor_id_to_expenses_table',1),(42,'2021_03_13_032624_add_code_to_doctors_table',1),(43,'2021_03_13_175226_add_signature_to_users_table',1),(44,'2021_03_13_180751_add_sinature_to_groups_table',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `modules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `modules` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `modules` WRITE;
/*!40000 ALTER TABLE `modules` DISABLE KEYS */;
INSERT INTO `modules` VALUES (1,'tests','2022-11-05 04:38:49','2022-11-05 04:38:49'),(2,'cultures','2022-11-05 04:38:49','2022-11-05 04:38:49'),(3,'antibiotics','2022-11-05 04:38:49','2022-11-05 04:38:49'),(4,'culture options','2022-11-05 04:38:49','2022-11-05 04:38:49'),(5,'doctors','2022-11-05 04:38:49','2022-11-05 04:38:49'),(6,'groups tests','2022-11-05 04:38:49','2022-11-05 04:38:49'),(7,'patients','2022-11-05 04:38:49','2022-11-05 04:38:49'),(8,'tests reports','2022-11-05 04:38:49','2022-11-05 04:38:49'),(9,'roles','2022-11-05 04:38:49','2022-11-05 04:38:49'),(10,'users','2022-11-05 04:38:49','2022-11-05 04:38:49'),(11,'price list','2022-11-05 04:38:49','2022-11-05 04:38:49'),(12,'accounting reports','2022-11-05 04:38:49','2022-11-05 04:38:49'),(13,'Home visits','2022-11-05 04:38:49','2022-11-05 04:38:49'),(14,'Branches','2022-11-05 04:38:49','2022-11-05 04:38:49'),(15,'contracts','2022-11-05 04:38:49','2022-11-05 04:38:49'),(16,'expense categories','2022-11-05 04:38:49','2022-11-05 04:38:49'),(17,'Expenses','2022-11-05 04:38:49','2022-11-05 04:38:49'),(18,'Backups','2022-11-05 04:38:49','2022-11-05 04:38:49'),(19,'setting','2022-11-05 04:38:49','2022-11-05 04:38:49'),(20,'Chat','2022-11-05 04:38:49','2022-11-05 04:38:49'),(21,'Actvity logs','2022-11-05 04:38:49','2022-11-05 04:38:49'),(22,'Translation','2022-11-05 04:38:49','2022-11-05 04:38:49');
/*!40000 ALTER TABLE `modules` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `client_id` bigint(20) unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `scopes` text COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_access_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_auth_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `client_id` bigint(20) unsigned NOT NULL,
  `scopes` text COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_auth_codes_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_auth_codes` WRITE;
/*!40000 ALTER TABLE `oauth_auth_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_auth_codes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_clients` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `provider` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `redirect` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_clients` WRITE;
/*!40000 ALTER TABLE `oauth_clients` DISABLE KEYS */;
INSERT INTO `oauth_clients` VALUES (1,NULL,'lab Personal Access Client','gSLYua268YtuJSW3tQ1XpQ0kmO8B3WRpdQRBnIy9',NULL,'http://localhost',1,0,0,'2022-11-05 04:38:52','2022-11-05 04:38:52'),(2,NULL,'lab Password Grant Client','516cly2t2iqtzLshkDeKMXRjKuiGjaAIptw5byGk','users','http://localhost',0,1,0,'2022-11-05 04:38:52','2022-11-05 04:38:52'),(3,NULL,'lab Personal Access Client','ZmmfCTc1TxzkS5Lo8lqFYSa0M1v6CHF9ItMFQSPM',NULL,'http://localhost',1,0,0,'2022-11-05 04:38:52','2022-11-05 04:38:52'),(4,NULL,'lab Password Grant Client','3BIGwdcLoc7Uo3CX3sWE4LEGS0OuxpTQJ7K0vcTk','users','http://localhost',0,1,0,'2022-11-05 04:38:52','2022-11-05 04:38:52');
/*!40000 ALTER TABLE `oauth_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_personal_access_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_personal_access_clients` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_personal_access_clients` WRITE;
/*!40000 ALTER TABLE `oauth_personal_access_clients` DISABLE KEYS */;
INSERT INTO `oauth_personal_access_clients` VALUES (1,1,'2022-11-05 04:38:52','2022-11-05 04:38:52'),(2,3,'2022-11-05 04:38:52','2022-11-05 04:38:52');
/*!40000 ALTER TABLE `oauth_personal_access_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_refresh_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `access_token_id` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_refresh_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_refresh_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_refresh_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `patients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `patients` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gender` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `patients` WRITE;
/*!40000 ALTER TABLE `patients` DISABLE KEYS */;
INSERT INTO `patients` VALUES (1,'1593914720','patient','male','28-08-1995','+201063955280','osamamohamed2050@gmail.com','Egypt',NULL,'2022-11-05 04:38:50','2022-11-05 04:38:50');
/*!40000 ALTER TABLE `patients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `module_id` int(11) DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES (1,1,'View','view_test',NULL,NULL),(2,1,'Create','create_test',NULL,NULL),(3,1,'Edit','edit_test',NULL,NULL),(4,1,'Delete','delete_test',NULL,NULL),(5,2,'View','view_culture',NULL,NULL),(6,2,'Create','create_culture',NULL,NULL),(7,2,'Edit','edit_culture',NULL,NULL),(8,2,'Delete','delete_culture',NULL,NULL),(9,3,'View','view_antibiotic',NULL,NULL),(10,3,'Create','create_antibiotic',NULL,NULL),(11,3,'Edit','edit_antibiotic',NULL,NULL),(12,3,'Delete','delete_antibiotic',NULL,NULL),(13,4,'View','view_culture_option',NULL,NULL),(14,4,'Create','create_culture_option',NULL,NULL),(15,4,'Edit','edit_culture_option',NULL,NULL),(16,4,'Delete','delete_culture_option',NULL,NULL),(17,5,'View','view_doctor',NULL,NULL),(18,5,'Create','create_doctor',NULL,NULL),(19,5,'Edit','edit_doctor',NULL,NULL),(20,5,'Delete','delete_doctor',NULL,NULL),(21,6,'View','view_group',NULL,NULL),(22,6,'Create','create_group',NULL,NULL),(23,6,'Edit','edit_group',NULL,NULL),(24,6,'Delete','delete_group',NULL,NULL),(25,7,'View','view_patient',NULL,NULL),(26,7,'Create','create_patient',NULL,NULL),(27,7,'Edit','edit_patient',NULL,NULL),(28,7,'Delete','delete_patient',NULL,NULL),(29,8,'View','view_report',NULL,NULL),(30,8,'Create','create_report',NULL,NULL),(31,8,'Edit','edit_report',NULL,NULL),(32,8,'Delete','delete_report',NULL,NULL),(33,8,'Sign','sign_report',NULL,NULL),(34,9,'View','view_role',NULL,NULL),(35,9,'Create','create_role',NULL,NULL),(36,9,'Edit','edit_role',NULL,NULL),(37,9,'Delete','delete_role',NULL,NULL),(38,10,'View','view_user',NULL,NULL),(39,10,'Create','create_user',NULL,NULL),(40,10,'Edit','edit_user',NULL,NULL),(41,10,'Delete','delete_user',NULL,NULL),(42,11,'View tests prices','view_test_prices',NULL,NULL),(43,11,'update tests prices','update_test_prices',NULL,NULL),(44,11,'View cultures prices','view_culture_prices',NULL,NULL),(45,11,'Update cultures prices','update_culture_prices',NULL,NULL),(46,12,'View','view_accounting_reports',NULL,NULL),(47,12,'Generate','generate_report_accounting',NULL,NULL),(48,13,'View','view_visit',NULL,NULL),(49,13,'Create','create_visit',NULL,NULL),(50,13,'Edit','edit_visit',NULL,NULL),(51,13,'Delete','delete_visit',NULL,NULL),(52,14,'View','view_branch',NULL,NULL),(53,14,'Create','create_branch',NULL,NULL),(54,14,'Edit','edit_branch',NULL,NULL),(55,14,'Delete','delete_branch',NULL,NULL),(56,15,'View','view_contract',NULL,NULL),(57,15,'Create','create_contract',NULL,NULL),(58,15,'Edit','edit_contract',NULL,NULL),(59,15,'Delete','delete_contract',NULL,NULL),(60,16,'View','view_expense_category',NULL,NULL),(61,16,'Create','create_expense_category',NULL,NULL),(62,16,'Edit','edit_expense_category',NULL,NULL),(63,16,'Delete','delete_expense_category',NULL,NULL),(64,17,'View','view_expense',NULL,NULL),(65,17,'Create','create_expense',NULL,NULL),(66,17,'Edit','edit_expense',NULL,NULL),(67,17,'Delete','delete_expense',NULL,NULL),(68,18,'View','view_backup',NULL,NULL),(69,18,'Create','create_backup',NULL,NULL),(70,18,'Delete','delete_backup',NULL,NULL),(71,19,'Update','view_setting',NULL,NULL),(72,20,'View','view_chat',NULL,NULL),(73,21,'View','view_activity_log',NULL,NULL),(74,21,'Clear','clear_activity_log',NULL,NULL),(75,22,'View','view_translation',NULL,NULL),(76,22,'Edit','edit_translation',NULL,NULL);
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `role_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `role_permissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `role_id` int(11) DEFAULT NULL,
  `permission_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `role_permissions` WRITE;
/*!40000 ALTER TABLE `role_permissions` DISABLE KEYS */;
INSERT INTO `role_permissions` VALUES (1,1,1,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(2,1,2,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(3,1,3,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(4,1,4,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(5,1,5,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(6,1,6,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(7,1,7,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(8,1,8,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(9,1,9,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(10,1,10,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(11,1,11,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(12,1,12,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(13,1,13,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(14,1,14,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(15,1,15,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(16,1,16,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(17,1,17,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(18,1,18,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(19,1,19,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(20,1,20,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(21,1,21,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(22,1,22,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(23,1,23,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(24,1,24,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(25,1,25,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(26,1,26,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(27,1,27,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(28,1,28,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(29,1,29,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(30,1,30,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(31,1,31,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(32,1,32,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(33,1,33,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(34,1,34,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(35,1,35,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(36,1,36,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(37,1,37,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(38,1,38,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(39,1,39,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(40,1,40,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(41,1,41,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(42,1,42,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(43,1,43,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(44,1,44,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(45,1,45,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(46,1,46,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(47,1,47,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(48,1,48,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(49,1,49,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(50,1,50,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(51,1,51,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(52,1,52,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(53,1,53,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(54,1,54,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(55,1,55,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(56,1,56,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(57,1,57,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(58,1,58,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(59,1,59,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(60,1,60,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(61,1,61,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(62,1,62,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(63,1,63,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(64,1,64,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(65,1,65,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(66,1,66,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(67,1,67,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(68,1,68,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(69,1,69,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(70,1,70,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(71,1,71,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(72,1,72,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(73,1,73,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(74,1,74,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(75,1,75,'2022-11-05 04:38:50','2022-11-05 04:38:50'),(76,1,76,'2022-11-05 04:38:50','2022-11-05 04:38:50');
/*!40000 ALTER TABLE `role_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `roles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'super_admin','2022-11-05 04:38:50','2022-11-05 04:38:50');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (1,'info','{\"name\":\"ExtremeLab\",\"currency\":\"EGP\",\"reports_logo\":\"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\",\"address\":\"Egypt\",\"phone\":\"+2\",\"email\":\"info@lab.com\",\"website\":\"lab.com\",\"socials\":{\"facebook\":\"https://facebook.com\",\"twitter\":\"https://twitter.com\",\"instagram\":\"https://instagram.com\",\"youtube\":\"https://youtube.com\"},\"footer\":\"All rights are reserved\"}',NULL,NULL),(2,'reports','{\"show_header\":true,\"show_footer\":true,\"show_signature\":true,\"margin-top\":\"0\",\"margin-right\":\"20\",\"margin-bottom\":\"20\",\"margin-left\":\"20\",\"content-margin-top\":\"230\",\"content-margin-bottom\":\"220\",\"footer\":\"footer here\",\"branch_name\":{\"color\":\"#000000\",\"font-size\":\"12\",\"font-family\":\"sans-serif\"},\"branch_info\":{\"color\":\"#000000\",\"font-size\":\"12\",\"font-family\":\"sans-serif\"},\"patient_title\":{\"color\":\"#000000\",\"font-size\":\"12\",\"font-family\":\"sans-serif\"},\"patient_data\":{\"color\":\"#000000\",\"font-size\":\"12\",\"font-family\":\"sans-serif\"},\"test_title\":{\"color\":\"#000000\",\"font-size\":\"12\",\"font-family\":\"sans-serif\"},\"test_name\":{\"color\":\"#000000\",\"font-size\":\"12\",\"font-family\":\"sans-serif\"},\"test_head\":{\"color\":\"#000000\",\"font-size\":\"12\",\"font-family\":\"sans-serif\"},\"result\":{\"color\":\"#000000\",\"font-size\":\"12\",\"font-family\":\"sans-serif\"},\"unit\":{\"color\":\"#000000\",\"font-size\":\"12\",\"font-family\":\"sans-serif\"},\"reference_range\":{\"color\":\"#000000\",\"font-size\":\"12\",\"font-family\":\"sans-serif\"},\"status\":{\"color\":\"#000000\",\"font-size\":\"12\",\"font-family\":\"sans-serif\"},\"comment\":{\"color\":\"#000000\",\"font-size\":\"12\",\"font-family\":\"sans-serif\"},\"signature\":{\"color\":\"#000000\",\"font-size\":\"12\",\"font-family\":\"sans-serif\"},\"antibiotic_name\":{\"color\":\"#000000\",\"font-size\":\"12\",\"font-family\":\"sans-serif\"},\"sensitivity\":{\"color\":\"#000000\",\"font-size\":\"12\",\"font-family\":\"sans-serif\"},\"commercial_name\":{\"color\":\"#000000\",\"font-size\":\"12\",\"font-family\":\"sans-serif\"},\"report_footer\":{\"color\":\"#000000\",\"font-size\":\"12\",\"font-family\":\"sans-serif\",\"text-align\":\"center\"}}',NULL,NULL),(3,'emails','{\"host\":\"\",\"port\":\"\",\"username\":\"\",\"password\":\"\",\"encryption\":\"\",\"from_address\":\"\",\"from_name\":\"\",\"header_color\":\"#c43e00\",\"footer_color\":\"#363636\",\"patient_code\":{\"active\":false,\"subject\":\"Patient Code\",\"body\":\"<p>Welcome , {patient_name}<\\/p><p>Your patient code is : {patient_code}&nbsp;<\\/p>\"},\"reset_password\":{\"active\":false,\"subject\":\"Reset Password\",\"body\":\"\"},\"tests_notification\":{\"active\":false,\"subject\":\"tests reports completed\",\"body\":\"welcome , {patient_name} <br>  your tests are ready now .. you can check tests by using your patient code : {patient_code}\"}}',NULL,NULL),(4,'sms','{\"sid\":\"\",\"token\":\"\",\"from\":\"\",\"patient_code\":{\"active\":false,\"message\":\"welcome {patient_name} , your patient code is {patient_code}\"},\"tests_notification\":{\"active\":false,\"message\":\"welcome {patient_name} , your tests are ready now .. you can check tests by using your patient code : {patient_code}\"}}',NULL,NULL),(5,'whatsapp','{\"receipt\":{\"active\":false,\"message\":\"welcome {patient_name} , receipt link is {receipt_link}\" },\"report\":{\"active\":false,\"message\":\"welcome {patient_name} , tests report link is {report_link}\"}}',NULL,NULL),(6,'api_keys','{\"google_map\":\"\"}',NULL,NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `test_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `test_options` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `test_id` int(11) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `test_options` WRITE;
/*!40000 ALTER TABLE `test_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `test_options` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `tests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `tests` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) DEFAULT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shortcut` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sample_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `unit` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_range` text COLLATE utf8mb4_unicode_ci,
  `type` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `separated` tinyint(1) NOT NULL DEFAULT '0',
  `price` double NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `title` tinyint(1) DEFAULT '0',
  `precautions` text COLLATE utf8mb4_unicode_ci,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `tests` WRITE;
/*!40000 ALTER TABLE `tests` DISABLE KEYS */;
INSERT INTO `tests` VALUES (1,0,'Complete Blood Count','CBC','blood',NULL,NULL,'',0,30,0,0,NULL,NULL),(2,1,'hgb-hemoglobin',NULL,'blood','g/dl','','text',1,0,0,0,NULL,NULL),(3,1,'hct-hematocrit',NULL,'blood','%','','text',0,0,0,0,NULL,NULL),(4,1,'RBC-Erythrocytes',NULL,'blood','million/µl','','text',0,0,0,0,NULL,NULL),(5,1,'MCV',NULL,'blood','fl','','text',0,0,0,0,NULL,NULL),(6,1,'MCH',NULL,'blood','pg','','text',0,0,0,0,NULL,NULL),(7,1,'MCHC',NULL,'blood','g/dl','','text',0,0,0,0,NULL,NULL),(8,1,'RDW-CV',NULL,'blood','%','','text',0,0,0,0,NULL,NULL),(9,1,'pit-platelet',NULL,'blood','10^3/µ','','text',0,0,0,0,NULL,NULL),(10,1,'MPV',NULL,'blood','fl','','text',0,0,0,0,NULL,NULL),(11,1,'PCT-PLATELETCRIT',NULL,'blood','%','','text',0,0,0,0,NULL,NULL),(12,1,'PDW',NULL,'blood','%','','text',0,0,0,0,NULL,NULL);
/*!40000 ALTER TABLE `tests` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `user_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_roles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `role_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `user_roles` WRITE;
/*!40000 ALTER TABLE `user_roles` DISABLE KEYS */;
INSERT INTO `user_roles` VALUES (1,1,1,'2022-11-05 04:38:50','2022-11-05 04:38:50');
/*!40000 ALTER TABLE `user_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` datetime DEFAULT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `token` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `signature` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'Super Admin','super_admin@lab.com',NULL,'$2y$10$C10/1J4soO9GIUf50tHgGuuisuhEsAOAo1kg91W8eEQxjWNBCI1Qu',NULL,'JB79IIF0QVosta6cBc2kf2g5NsoSXesf','2022-11-05 04:38:50','2022-11-05 04:38:50',NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `visits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `visits` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) DEFAULT NULL,
  `lat` double(8,2) DEFAULT NULL,
  `lng` double(8,2) DEFAULT NULL,
  `zoom_level` int(11) DEFAULT NULL,
  `visit_date` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attach` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read` tinyint(1) NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `visits` WRITE;
/*!40000 ALTER TABLE `visits` DISABLE KEYS */;
/*!40000 ALTER TABLE `visits` ENABLE KEYS */;
UNLOCK TABLES;
/*!50112 SET @disable_bulk_load = IF (@is_rocksdb_supported, 'SET SESSION rocksdb_bulk_load = @old_rocksdb_bulk_load', 'SET @dummy_rocksdb_bulk_load = 0') */;
/*!50112 PREPARE s FROM @disable_bulk_load */;
/*!50112 EXECUTE s */;
/*!50112 DEALLOCATE PREPARE s */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

